REM eprogD the beginning of an eprom
REM programmer program Now includes Twos Comp 1/2/89 2:47pm

DEFLNG a-z

LIBRARY "exec.library"
DECLARE FUNCTION AllocMem&() LIBRARY

EmemBase&=AllocMem&(65536&,65541&) ' 64k of stable fast cleared ram
IF EmemBase&=0 THEN END ' TROUBLE! not enough memory 
ParPort&=12574977&
ParDDR&=12575489&
CtrlPort&=12570624&
CtrlDDR&=12571136&
EType$=""
EmemTop&=EmemBase&+65535& ' the last byte to tread on
RamBot&=EmemBase&
Quantity&=0
EpromBot&=0
Clock0=0
Clock1=4
volts12=128
volts21=64
volts25=192

MENU 1,0,1,"Project    "
MENU 1,1,1,"Open      "
MENU 1,2,1,"Save      "
MENU 1,3,1,"File Size "
MENU 1,4,1,"Read Eprom"
MENU 1,5,1,"Burn Eprom"
MENU 1,6,1,"Fill Ram  "
MENU 1,7,1,"Quit      "
MENU 2,0,1,"Eproms     "
GOSUB EpromMenu
MENU 3,0,1,"Goodies    "
MENU 3,1,1,"Twos Comp "
MENU 3,2,1,"Expand    "
MENU 3,3,1,"Compress  "
MENU 4,0,1,""
PRINT "Eprommer by Bob Blick"
PRINT "Box 916"
PRINT "Mendocino, CA 95460"
PRINT "March 23, 1989"

SquareOne:
  ON MENU GOSUB MenuHandler
  MENU ON

x=1:WHILE x=1:SLEEP:WEND

ThatsIt:
  CALL FreeMem&(EmemBase&,65536&) ' release ram
  LIBRARY CLOSE
  Address&=0
  GOSUB SetAddr
  POKE CtrlDDR,0 ' make ctrl pins hi-Z
  POKE ParDDR,0 ' make port hi-Z
  MENU RESET
  END

InitPorts:
  POKE CtrlDDR&,7
  POKE CtrlPort&,3
  POKE ParDDR&,255
  POKE ParPort&,255
  POKE CtrlPort&,7
  POKE CtrlPort&,3
  Address&=0
  GOSUB SetAddr
  RETURN
  
EpromMenu:
  MENU 2,1,1,"  2716    "
  MENU 2,2,1,"  2732    "
  MENU 2,3,1,"  2732A   "
  MENU 2,4,1,"  2764    "
  MENU 2,5,1,"  2764A   "
  MENU 2,6,1,"  27128   "
  MENU 2,7,1,"  27256   "
  MENU 2,8,1,"  27512   "
  RETURN
    
MenuHandler:
  MENU OFF 
  ON MENU(0) GOSUB Menu1, Menu2, Menu3, Menu4
  MENU ON
  RETURN

Menu1:
  ON MENU(1) GOSUB M1Item1, M1Item2, M1Item3, M1Item4, M1Item5, M1Item6, M1Item7,

  RETURN

Menu2:
  p=1
  IF EpromType$="" THEN GOSUB InitPorts
  IF p=0 THEN RETURN
  Title$="Just a reminder"
  Msg$="Check for correct personality module"
  GOSUB Requester
  ON MENU(1) GOSUB M2Item1, M2Item2, M2Item3, M2Item4, M2Item5, M2Item6, M2Item7, M2Item8,
  GOSUB SetCycleParams
  RETURN

Menu3:
  ON MENU(1) GOSUB M3Item1, M3Item2, M3Item3,
    RETURN

Menu4:
  RETURN
  
M1Item1:
  GOSUB LoadDiskFile
  RETURN

M1Item2:
  GOSUB SaveDiskFile
  RETURN

M1Item3:
  Title$="Just Curious?"
  Msg$="Enter Filename"
  GOSUB StringGadget
  IF p=0 THEN RETURN
  ON ERROR GOTO ErrorTrap
  OPEN file$ FOR INPUT AS 1
  Title$="Your Answer"
  Msg$="The file is "+STR$(LOF(1))+" bytes long"
  CLOSE 1
  ON ERROR GOTO 0
  GOSUB Requester
  RETURN

M1Item4:
  GOSUB ReadEprom
  RETURN

M1Item5:
  GOSUB WriteEprom
  RETURN

M1Item6:
  GOSUB FillRam
  RETURN
  
M1Item7:
  x=0 ' time to go bye-bye
  RETURN

ZOut:
  MOUSE OFF
  z=0
  RETURN
  
M2Item1:
  EpromType$="2716"
  VoltVal=volts25
  Size&=2048&
  ReadParam=0:WriteParam=3:LeaveParam=3:InhibitParam=1
  POKE CtrlPort&,LeaveParam
  GOSUB EpromMenu:MENU 2,1,1,"* 2716   "
  RETURN
  
M2Item2:
  EpromType$="2732"
  VoltVal=volts25
  Size&=4096&
  ReadParam=0:WriteParam=1:LeaveParam=3:InhibitParam=3
  POKE CtrlPort&,LeaveParam
  GOSUB EpromMenu
  MENU 2,2,1,"* 2732   "
  RETURN
  
M2Item3:
  EpromType$="2732A"
  VoltVal=volts21
  Size&=4096&
  ReadParam=0:WriteParam=1:LeaveParam=3:InhibitParam=3
  POKE CtrlPort&,LeaveParam
  GOSUB EpromMenu
  MENU 2,3,1,"* 2732A  "
  RETURN
  
M2Item4:
  EpromType$="2764"
  VoltVal=volts21
  Size&=8192&
  ReadParam=2:WriteParam=1:LeaveParam=3:InhibitParam=3
  POKE CtrlPort&,LeaveParam
  GOSUB EpromMenu
  MENU 2,4,1,"* 2764   "
  RETURN
  
M2Item5:
  EpromType$="2764A"
  VoltVal=volts12
  Size&=8192&
  ReadParam=2:WriteParam=1:LeaveParam=3:InhibitParam=3
  POKE CtrlPort&,LeaveParam
  GOSUB EpromMenu
  MENU 2,5,1,"* 2764A  "
  RETURN
  
M2Item6:
  EpromType$="27128"
  VoltVal=volts12
  Size&=16384&
  ReadParam=2:WriteParam=1:LeaveParam=3:InhibitParam=3
  POKE CtrlPort&,LeaveParam
  GOSUB EpromMenu
  MENU 2,6,1,"* 27128  "
  RETURN
  
M2Item7:
  EpromType$="27256"
  VoltVal=volts12
  Size&=32768&
  ReadParam=0:WriteParam=1:LeaveParam=3:InhibitParam=3
  POKE CtrlPort&,LeaveParam
  GOSUB EpromMenu
  MENU 2,7,1,"* 27256  "
  RETURN
  
M2Item8:
  EpromType$="27512"
  VoltVal=volts12
  Size&=65536&
  ReadParam=0:WriteParam=1:LeaveParam=3:InhibitParam=3
  POKE CtrlPort&,LeaveParam
  GOSUB EpromMenu
  MENU 2,8,1,"* 27512  "
  RETURN
  
M3Item1:
  GOSUB TwosComp
  RETURN
  
M3Item2:
  RETURN
  
M3Item3:
  GOSUB GenerateCompressArray
  RETURN
  
LoadDiskFile:
  Title$= "Load File"
  Msg$= "Enter name of disk file"
  GOSUB StringGadget
  IF p=0 THEN RETURN
  diskfile$=file$
  ON ERROR GOTO ErrorTrap
  OPEN diskfile$ FOR INPUT AS 1
  GOSUB AskRamBot
  i=0:WhereRam&=RamBot&
  WHILE (NOT EOF(1)) AND (WhereRam&<=EmemTop&)
    b$=INPUT$(1,1)
    onebyte=ASC(b$)
    POKE WhereRam&,onebyte
    i=i+1:WhereRam&=WhereRam+1
    WEND
  DoneLoad:
  CLOSE #1
  ON ERROR GOTO 0
  Title$="Now Hear This!"
  Msg$="We loaded "+STR$(i)+" bytes"
  GOSUB Requester
  RETURN
  
SaveDiskFile:
  Title$= "Save File"
  Msg$= "Enter name of disk file"
  GOSUB StringGadget
  IF p=0 THEN RETURN
  diskfile$=file$
  ON ERROR GOTO ErrorTrap
  OPEN diskfile$ FOR OUTPUT AS 1
  GOSUB AskRamBot:IF q=0 THEN GOTO DoneSave
  GOSUB AskQuantity:IF q=0 THEN GOTO DoneSave
  i=0
  WhereRam&=RamBot&
  WHILE i<Quantity&
  c$=CHR$(PEEK(WhereRam&))
  PRINT#1,c$;
  i=i+1:WhereRam&=WhereRam&+1
  WEND
  DoneSave:
    CLOSE 1
    ON ERROR GOTO 0
    Title$="Now Hear This"
    Msg$="We saved "+STR$(i)+" bytes"
    GOSUB Requester
  RETURN
  
ReadEprom:
  GOSUB EpromSpec
  IF q=0 THEN RETURN
  GOSUB AskRamBot:IF q=0 THEN RETURN
  GOSUB AskQuantity:IF q=0 THEN RETURN
  IF (EpromBot&+Quantity&)>Size& THEN
    Msg$="Excess will be ignored"
    GOSUB Requester:IF p=0 THEN RETURN
  END IF
  i=0
  Address&=EpromBot&
  WhereRam&=RamBot&
  WHILE Address&<Size& AND i<Quantity&
    GOSUB SetAddr
    GOSUB ReadByte
    POKE WhereRam&,DataIn
    i=i+1:Address&=Address&+1:WhereRam&=WhereRam+1
  WEND
  Title$="For your information"
  Msg$="We read"+STR$(i)+" bytes"
  GOSUB Requester
  RETURN
  
WriteEprom:
  GOSUB EpromSpec
  IF q=0 THEN RETURN
  GOSUB AskRamBot:IF q=0 THEN RETURN
  GOSUB AskQuantity:IF q=0 THEN RETURN
  i=0
  Address&=EpromBot&
  WhereRam&=RamBot&
  WriteError=0

  WHILE Address&<Size& AND i<Quantity& AND WriteError=0
    GOSUB SetAddr
    DataOut=PEEK(WhereRam&)
    GOSUB WriteCycle
    i=i+1:Address&=Address&+1:WhereRam&=WhereRam+1
  WEND
  BEEP
  Title$="For your information"
  IF WriteError=0 THEN Msg$="We wrote"+STR$(i)+" bytes perfectly"
  IF WriteError=1 THEN Msg$="Eprom already has data at address"+STR$(Address&-1)
  IF WriteError=2 THEN Msg$="Verify error at Eprom address"+STR$(Address&-1)
  GOSUB Requester
  RETURN
  

ReadByte:
  POKE ParDDR&,0 ' inputting
  POKE CtrlPort&,Read0 ' Give it to me
  DataIn = PEEK(ParPort)
  POKE CtrlPort&,Read1 ' leaving it
  RETURN

SetAddr:
  POKE ParDDR&,255 ' outputting
  POKE ParPort&,253 ' VPP control hi,set hi byte
  POKE CtrlPort&,Addr0 ' clock command
  HiByte = ((Address& AND 65280&)/256) ' mask off lower bits
  POKE ParPort&, HiByte
  POKE CtrlPort&,Addr1 ' clock data to hibyte addr latch
  POKE ParPort&,254 ' VPP control hi, set lo byte
  POKE CtrlPort&,Addr2 ' clock command
  LoByte = Address& AND 255 ' mask off upper bits
  POKE ParPort&, LoByte
  POKE CtrlPort&,Addr3 ' clock addr to lower addr latch
  RETURN

WriteCycle:
  GOSUB ReadByte
  IF DataIn<>255 THEN
    WriteError=1
    RETURN
  END IF
  IF DataOut=255 THEN
    WriteError=0
    RETURN
  END IF
  n=0:m=0
  Cycle:
    PulseTimer=15 'one millisec
    GOSUB WriteByte
    GOSUB ReadByte
    n=n+1
    IF DataIn=DataOut THEN 
      PulseTimer=n*75
      IF PulseTimer>300 THEN PulseTimer=300
      GOSUB WriteByte
      GOSUB ReadByte
      WriteError=0
      IF DataIn<>DataOut THEN WriteError=2
      RETURN
    END IF
    IF n<20 THEN GOTO Cycle
  WriteError=2 
  RETURN
  
  
WriteByte:
  ' we get a .003 sec pulse uncompiled
  POKE ParDDR&,255 ' we will be outputting
  POKE ParPort&,Write0 ' set voltage
  POKE CtrlPort&,Write1 ' turn on juice!
  POKE ParPort&,DataOut ' Here is a byte
  POKE CtrlPort&,Write2 ' we are burning eprom now
  FOR yawn=1 TO PulseTimer
  NEXT yawn
  POKE CtrlPort&,Write3 ' inhibited but still hot
  POKE ParPort&,255 ' set voltage
  POKE CtrlPort&,Write4 ' shut off hi voltage
  POKE CtrlPort&,Write5 ' ready for next command
  RETURN

SetCycleParams:
  Write0=223-VoltVal
  Write1=InhibitParam+Clock1
  Write2=WriteParam+Clock1
  Write3=InhibitParam+Clock0
  Write4=InhibitParam+Clock1
  Write5=LeaveParam+Clock0
  Read0=ReadParam+Clock0
  Read1=LeaveParam+Clock0
  Addr0=LeaveParam+Clock1
  Addr1=LeaveParam+Clock0
  Addr2=LeaveParam+Clock1
  Addr3=LeaveParam+Clock0
  RETURN

FillRam:
  GOSUB AskRamBot:IF q=0 THEN RETURN
  GOSUB AskQuantity:IF q=0 THEN RETURN
  Msg$="Number from 0 to 255 to fill with?"
  GOSUB StringGadget:IF p=0 THEN RETURN
  FillDirt=ABS(VAL(file$))
  IF FillDirt>255 THEN
    BEEP
    RETURN
  END IF
  i=0
  WhereRam&=RamBot&
  WHILE i<Quantity&
    POKE WhereRam&,FillDirt
    i=i+1:WhereRam&=WhereRam+1
  WEND
  Title$="For your information"
  Msg$="We filled"+STR$(i)+" bytes"
  GOSUB Requester
  RETURN
  
TwosComp:
  GOSUB AskRamBot:IF q=0 THEN RETURN
  GOSUB AskQuantity:IF q=0 THEN RETURN
  i=0
  WhereRam&=RamBot&
  WHILE i<Quantity&
    AByte=PEEK (WhereRam&)
    IF AByte>127 THEN
      AByte=AByte-128
      ELSE
      AByte=AByte+128
    END IF
    POKE WhereRam&,AByte
    i=i+1:WhereRam&=WhereRam+1
  WEND
  Title$="For your information"
  Msg$="We changed"+STR$(i)+" bytes"
  GOSUB Requester
  RETURN
  
AskRamBot:
  q=1
  Msg$="Enter starting RAM address ("+STR$(RamBot&-EmemBase&)+")"
  GOSUB StringGadget:IF p=0 THEN 
  q=0:RETURN
  END IF
  IF file$<>"" THEN RamBot&=ABS(VAL(file$))+EmemBase&
  IF RamBot&>EmemTop& THEN
    Msg$="RAM addresses are from 0 to 65535"
    GOSUB Requester
    q=0:RETURN
  END IF
  RETURN

AskQuantity:
  q=1
  Msg$="Enter number of bytes ("+STR$(Quantity&)+")"
  GOSUB StringGadget:IF p=0 THEN
  q=0:RETURN
  END IF
  IF file$<>"" THEN Quantity&=ABS(VAL(file$))
  IF (RamBot&+Quantity&)>(EmemTop&+1) THEN
    Msg$="Excess will be ignored"
    GOSUB Requester:IF p=0 THEN
    q=0:RETURN
  END IF
  END IF
  r=EmemTop&-RamBot&+1
  IF r<Quantity& THEN Quantity&=r
  RETURN
  
EpromSpec:
  q=1
  IF EpromType$="" THEN
    Title$="Program Request"
    Msg$="You need to select an EPROM type"
    GOSUB Requester
    q=0
    RETURN
  END IF
  Title$="Program Request"
  Msg$="Enter starting EPROM Address ("+STR$(EpromBot&)+")"
  GOSUB StringGadget:IF p=0 THEN
  q=0:RETURN
  END IF
  IF file$<>"" THEN EpromBot&=ABS(VAL(file$))
  IF EpromBot&>=Size& THEN
    Msg$="The "+EpromType$+" has only"+STR$(Size&)+" bytes!"
    GOSUB Requester
    q=0
    RETURN
  END IF
  RETURN
  
GenerateCompressArray:
  RETURN
  
Requester:
  WINDOW 2, Title$,(200,90)-(500,150),0
  LOCATE 2,1
  PRINT Msg$
  GOSUB GadgetMake
  ON MOUSE GOSUB OKHandler
  MOUSE ON
  z=1:WHILE z=1:SLEEP:WEND
  WINDOW 1
  WINDOW CLOSE 2
  RETURN
    
StringGadget:
  WINDOW 2, Title$,(100,50)-(400,100),0
  LOCATE 2,1
  PRINT Msg$
  LINE (20,15)-(280,25),,b
  LOCATE 3,4:c=0:file$="":x$="":WINDOW 2
    WHILE x$<>CHR$(13)
     x$=INPUT$(1)
     IF x$> CHR$(31) THEN
       PRINT x$;
       file$=file$+x$
       c=c+1
     END IF
   WEND
   GOSUB GadgetMake
   ON MOUSE GOSUB OKHandler
   MOUSE ON
   z=1:WHILE z=1:SLEEP:WEND
   WINDOW 1
   WINDOW CLOSE 2
   RETURN
   
GadgetMake:
  LINE (50,30)-(120,45),3,b
  LINE (175,30)-(245,45),3,b
  LOCATE 5,11:PRINT "OK"
  LOCATE 5,24:PRINT "Cancel"
  RETURN

OKHandler:
  MOUSE OFF
  IF WINDOW(0) <> 2 THEN WINDOW OUTPUT 2:MOUSE ON:RETURN
  m=MOUSE(0)
  a=MOUSE(3):b=MOUSE(4)
  IF (a > 50 AND a < 120) AND (b > 30 AND b < 45) THEN GOSUB OK:RETURN
  IF (a > 175 AND a < 245) AND (b > 30 AND b < 45) THEN GOSUB Cancel:RETURN
  MOUSE ON
  RETURN
    
     OK:
        LINE (50,30)-(120,45),3,bf
        p=1
        z=0
        RETURN
        
     Cancel:
        LINE (175,30)-(245,45),3,bf
        p=0
        z=0
        RETURN
        
ErrorTrap:
  BEEP 'Get user's attention.
  IF ERR=53 THEN
    Msg$="FILE NOT FOUND."
    GOTO ExitError
  END IF
  IF ERR=61 THEN
    Msg$="DISK FULL."
    GOTO ExitError
  END IF
  IF ERR=64 THEN
    Msg$="BAD FILENAME."
    GOTO ExitError
  END IF
  IF ERR=67 THEN
    Msg$="DIRECTORY FULL."
    GOTO ExitError
  END IF
  IF ERR=68 THEN
    Msg$="DEVICE UNAVAILABLE."
    GOTO ExitError
  END IF
  IF ERR=70 THEN
    Msg$="DISK WRITE-PROTECTED."
    GOTO ExitError
  END IF
  IF ERR=74 THEN
    Msg$="UNKNOWN DISK VOLUME."
    GOTO ExitError
  END IF
  Msg$="ERROR NUMBER"+STR$(ERR)
  
  ExitError:
  ' Abort operation or try again.
  Title$="Somebody Goofed!"
  RESUME StillError
  StillError:
  GOSUB Requester
  CLOSE 1
  GOTO SquareOne
  
                                      
