/* Prototypes for the req.library for use with Lattice. */

/* If you aren't using a compiler that can handle pragmas, then define NOPRAGS */

#ifndef	REQLIBRARY_H
#include	<libraries/reqbase.h>
#endif

#ifndef __NOPROTO
#ifndef __PROTO
#define __PROTO(a) a
#endif
#else
#ifndef __PROTO
#define __PROTO(a) ()
#endif
#endif

#ifdef NOPRAGS
#define PRAGSTATE __stdargs
#else
#define PRAGSTATE
#endif


/*        Requesters          */

int  PRAGSTATE  FileRequester __PROTO((struct ReqFileRequester *));
void PRAGSTATE  PurgeFiles __PROTO((struct ReqFileRequester *));

int  PRAGSTATE  ColorRequester __PROTO((long));
int  PRAGSTATE  ExtendedColorRequester __PROTO((struct ExtendedColorRequester *));

long PRAGSTATE  TextRequest __PROTO((struct TRStructure *));
BOOL PRAGSTATE  GetLong __PROTO((struct GetLongStruct *));
BOOL PRAGSTATE  NewGetString __PROTO((struct GetStringStruct *));

/*          Utility Functions        */

void PRAGSTATE  Center __PROTO((struct NewWindow *,int,int));
char PRAGSTATE  RawKeyToAscii __PROTO((long,long,APTR));
void PRAGSTATE  MakeScrollBar __PROTO((struct ScrollBlock *,long,long,long,long));
void PRAGSTATE  MakeString __PROTO((char *,char *,char *,ULONG,ULONG,long,long));
void PRAGSTATE  MakeProp  __PROTO((char *,ULONG,ULONG,ULONG));
void PRAGSTATE  MakeGadget __PROTO((char *,char *,ULONG,ULONG));

void PRAGSTATE RealTimeScroll __PROTO((struct ReqScrollStruct *));

short PRAGSTATE SetSize __PROTO((long MaxVal, long ViewSize));
short PRAGSTATE SetLocation __PROTO((long MaxVal, long ViewSize, long Value));
short PRAGSTATE ReadLocation __PROTO((long MaxVal, long ViewSize, long PotValue));

long PRAGSTATE ReqFormat __PROTO((char *String, void *ControlList, char *ResultBuffer));

void PRAGSTATE LinkGadget __PROTO((char *Buffer,char *String,struct NewWindow *nw, ULONG X, ULONG Y));
void PRAGSTATE LinkStringGadget __PROTO((char *Buffer,char *StringBuf,
										 char *UndoBuf,struct NewWindow *nw,
										 short WidthBits,short NumChars,
										 short X, short Y));

void PRAGSTATE LinkPropGadget __PROTO(( char *Buffer,struct NewWindow *nw,
										short Width, short Height, short Flags,
										short Leftedge, short TopEdge));

void PRAGSTATE DrawBox __PROTO((struct RastPort *rp,short MinX,short MinY,short MaxX,short MaxY));


/*-------------------------------------------------------*/

