/*
 *
 * Linux-x86 software for eprommer "Quickbyte 2.0 (Amiga)"
 * ========================================================================
 * Copyright 1996 thh-computergraphics. Refer to GPL for copying.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this software; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 * Thorsten Hempel
 * Meisterstr. 23
 * 23919 Berkenthin
 * thh@valis.pumuckl.cubenet.de
 *
 *
 *
 *  linux/drivers/char/tio.c
 *	Copyright (C) 1996 by thh-computergraphics 
 *                         (thh@valis.pumuckl.cubenet.de).
 *  functions code based on mem.c:
 *	Copyright (C) 1991, 1992  Linus Torvalds
 *  modules code based on lp.c:
 *	Copyright (C) 1992 by Jim Weigand and Linus Torvalds
 *	Copyright (C) 1992,1993 by Michael K. Johnson
 *	 - Thanks much to Gunter Windau for pointing out to me where the error
 *	   checking ought to be.
 *	Copyright (C) 1993 by Nigel Gamble (added interrupt code)
 *	Copyright (C) 1994 by Alan Cox (Modularised it)
 *
 *
 * Description:
 *	This module is a support program in kernel space to ensure
 *	a precise timing on the parallel device for an eprom
 *	programming device. The real program with simple menu driven
 *	user interface in file "prommer.c".
 *
 *	Don't allow non root users to use the tio device, it could
 *	easily break system security!
 *
 */



#ifdef MODULE
#include <linux/module.h>
#include <linux/version.h>
#else
#define MOD_INC_USE_COUNT
#define MOD_DEC_USE_COUNT
#endif

#include <linux/errno.h>
#include <linux/kernel.h>
#include <linux/major.h>
#include <linux/sched.h>
#include <linux/malloc.h>
#include <linux/ioport.h>
#include <linux/fcntl.h>

#include <asm/io.h>
#include <asm/segment.h>
#include <asm/system.h>

#include <linux/delay.h>

#include "tio.h"
#include "prommer-hw.h"


/*-----------------------------------------------------------*/

static int open_count=0;
static int tio_port=-1;

#define MESSAGE "tio: timed io device V1.2 (c) thh-computergraphics\n"

/*-----------------------------------------------------------*/
/* port output                                               */
/*-----------------------------------------------------------*/


/* ausgabe von cmd an port, wobei D0 immer gesetzt ist! */
/* erfordert konstant 18 portzugriffe */
static void tio_write_port(int cmd, int port){
int i;
int data;

	/* 8 datenbits ausgeben */
	for (i=0;i<8;i++) {
		/* data bit i: 0 oder 1 schreiben  */
		if (cmd&128) data=BIT_DATA345;else data=0;
		cmd=cmd<<1;
		outb(BIT_OE3+data,port); 
		outb(BIT_OE3+data+BIT_CLOCK4,port);	/* clock -> high (=datenuebernahme) */	
/*		outb(BIT_OE3+data,port);	*/	/* clock -> low (kann eingespart werden)*/ 
		}

	outb(BIT_OE3+BIT_STROBE345,port);		/* datenuebernahme an latches */	
	outb(BIT_OE3,port);				/* ausgangszustand */
}


/*-----------------------------------------------------------*/
/* standard device driver interface                          */
/*-----------------------------------------------------------*/


static int lseek_tio(struct inode * inode,struct file * file,off_t offset,int origin){
	return -ESPIPE;
}


static int open_tio(struct inode * inode,struct file * file) {
	if (open_count>0) {
		return (-EBUSY);
		}
	MOD_INC_USE_COUNT;
	open_count++;
	return 0;
}

static void release_tio(struct inode * inode,struct file * file) {
	if (open_count>0) {
		open_count--;
		MOD_DEC_USE_COUNT;
		}
}


/* driver->user */
static int read_tio(struct inode * inode, struct file * file,char * buf, int count){
	return -EIO;
}


/* user->driver */
static int write_tio(struct inode * inode, struct file * file,const char * buf, int count){
	return -EIO;
}



static int ioctl_tio(struct inode *inode,struct file *file,unsigned int cmd,
	unsigned long args){

int retval = 0;

	switch (cmd) {
		case TIO_NOP:
			break;
		case TIO_PROG: {
			tiostruct *parms = (tiostruct*) args;
			long port;
			long delay;
			int  wert1;
			int  wert2;

			retval=verify_area(VERIFY_READ,(void*) parms,sizeof(tiostruct));
			if (retval) return(retval);

			port =get_user((long*) &(parms->port));
			delay=get_user((long*) &(parms->delay));
			wert1=get_user((int*)  &(parms->wert1));
			wert2=get_user((int*)  &(parms->wert2));

			if (port<0) {
				retval= -EINVAL;
				}
			else {
				cli();
				tio_write_port(wert1,port);
				udelay(delay);		
				tio_write_port(wert2,port);	
				sti();
				}
			} break;
		default:
			retval = -EINVAL;
		} /* switch */
	return retval;
}



static struct file_operations tio_fops = {
	lseek_tio,
	read_tio,
	write_tio,
	NULL,		/* tio_readdir */
	NULL,		/* tio_select */
	ioctl_tio,	/* tio_ioctl */
	NULL,		/* tio_mmap */
	open_tio,	/* tio_open */
	release_tio,	/* tio_release */
	NULL		/* fsync */
};


/*-----------------------------------------------------------*/
/* module interface and startup code			     */
/*-----------------------------------------------------------*/


#ifndef MODULE
define TIOKERNELMEM 0
long tio_init(long mem_start) {
	if (register_chrdev(TIO_MAJOR,"tio",&tio_fops)) {
		printk("unable to get major %d for tio dev\n", TIO_MAJOR);
		return mem_start;
		}
	cmd_buffer=mem_start;
	cmd_count=0;
	open_count=0;
	mem_start+=TIOKERNELMEM;
	printk(MESSAGE);
	return mem_start;
}

#else

/* nur fuer linux 1.x ??? */
/* char kernel_version[]= UTS_RELEASE;*/

int init_module(void) {
	if (register_chrdev(TIO_MAJOR,"tio",&tio_fops)) {
		printk("unable to get major %d for tio dev\n", TIO_MAJOR);
		return -EIO;
		}
	open_count=0;
	printk(MESSAGE);
	return 0;
}


void cleanup_module(void){
	if (MOD_IN_USE) {
		printk("tio: busy - remove delayed\n");
		}
        else {
		unregister_chrdev(TIO_MAJOR,"tio");
		printk("tio: device removed\n");
		}
}

#endif


/* end of file */
