#ifndef tio_H
#define tio_H

/*
 *
 * Linux-x86 software for eprommer "Quickbyte 2.0 (Amiga)"
 * ========================================================================
 * Copyright 1996 thh-computergraphics. Refer to GPL for copying.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this software; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 * Thorsten Hempel
 * Meisterstr. 23
 * 23919 Berkenthin
 * thh@valis.pumuckl.cubenet.de
 *
 *
 *
 *  linux/drivers/char/tio
 *	Copyright (C) 1996 by thh-computergraphics 
 *                         (thh@valis.pumuckl.cubenet.de).
 *
 * Description:
 *	This module is a support program in kernel space to ensure
 *	a precise timing on the parallel device for an eprom
 *	programming device. The real program with simple menu driven
 *	user interface in file "prommer.c".
 *
 *	Don't allow non root users to use the tio device, it could
 *	easily break system security!
 *
 */



/*-----------------------------------------------------------*/

/* 
 * These values are evaluated for my own system (P54C 75MHz Plato-PCI, LPT2);
 * I measured the timing with an analogue scope and got an error 
 * of some 30 us in TIO_IO_PROG*, so I chosed these adjusted values for my computer.
 * If you can measure your timing, adjust these values! 
 * The timing error results mainly from the slow tio_write_port().
 * 
 */

#define us_error 30

#define us10000	(10000-us_error)	/* (10000-30) us */
#define us1000	(1000-us_error)		/* (1000-30)  us */
#define	us200	(200-us_error)		/* (200-30)   us */
#define	us100	(100-us_error)		/* (100-30)   us */


/* device number */
#define TIO_MAJOR		60		/* private... */
#define TIO_MINOR		128		/* private... */

/* ioctl interface */
#define TIO_NOP			1144
#define TIO_PROG		1150		/* neuer ioctl */


/* structure for TIO_PROG parms */
typedef struct {
	unsigned long	port;
	unsigned long	delay;
	unsigned int	wert1;
	unsigned int	wert2;
} tiostruct;


#endif
